<?php
if (class_exists('MainWP_WP_Stream_Connector')) {
    class MainWPChildReportsConnectorSucuri extends MainWP_WP_Stream_Connector   
    {   

	/**
	 * Connector slug
	 *
	 * @var string
	 */
	public static $name = 'mainwp_sucuri';

	/**
	 * Actions registered for this connector
	 *
	 * @var array
	 */
	public static $actions = array(
		'mainwp_sucuri_scan',		
	);

	/**
	 * Return translated connector label
	 *
	 * @return string Translated connector label
	 */
	public static function get_label() {
		return __( 'MainWP Sucuri', 'default' );
	}

	/**
	 * Return translated action labels
	 *
	 * @return array Action label translations
	 */
	public static function get_action_labels() {
		return array(
			'mainwp_sucuri_scan'    => __( 'Scan', 'default' ),			
		);
	}

	/**
	 * Return translated context labels
	 *
	 * @return array Context label translations
	 */
	public static function get_context_labels() {
		return array(
			'mainwp_sucuri' => __( 'MainWP Sucuri', 'default' ),
		);
	}

	/**
	 * Add action links to Stream drop row in admin list screen
	 *
	 * @filter wp_stream_action_links_{connector}
	 * @param  array $links      Previous links registered
	 * @param  int   $record     Stream record
	 * @return array             Action links
	 */
	public static function action_links( $links, $record ) {
		if ( isset($record->object_id )) {
			
		}
		return $links;
	}

        public static function callback_mainwp_sucuri_scan($data, $scan_status) {
            $message = "";            
            if ($scan_status == "success") {
                $message = __("Sucuri scan success", "mainwp-child");                
                $scan_status = "success";
            } else {
                $message = __("Sucuri scan failed", "mainwp-child");                
                $scan_status = "failed";
            }
            
            $scan_result = unserialize(base64_decode($data));
            $status = $webtrust = "";            
            if (is_array($scan_result)) {
                $status = isset($scan_result['status']) ? $scan_result['status'] : "";
                $webtrust = isset($scan_result['webtrust']) ? $scan_result['webtrust'] : "";
            }
         
            self::log(
                $message,
                compact('scan_status', 'status', 'webtrust'),
                0,
                array( 'mainwp_sucuri' => 'mainwp_sucuri_scan' )
            );
        }
    }
}

